/*
 *
 *    Self Test
 *        Written by Kenichi Maehashi
 *
 *    Copyright (C) 2007-2017 Kenichi Maehashi, All rights reserved.
 *
 *    Contact:
 *        webmaster@kenichimaehashi.com
 *        http://www.KenichiMaehashi.com/
 *
 */


// *******************************************************************************
//  MAIN
// *******************************************************************************


//  *********** variables used in test process ***********
var testInstallation, testVersionCompatible, testVersionRecommended, testPlayerState, testCurrentTrack;
var iTunesVersion = "", iTunesPlayerState = -1, iTunesCurrentTrackName = "", iTunesException = null;

//  *********** start test session ***********
WScript.Echo("Lyrics Master - Self Test\n\ñvÓAg̃Rs[^ iTunes Ag@\ɗpł邩ǂff܂B\n\niTunes NāADȋȂĐAuOKv{^NbNĂB\nff͂Ɋ܂B");

runTest();

//  *********** test report ***********
var reportMsg = "eXg|[g\n\nyeXǧʁz";
var testFailed = false;

//  *********** test 1: installation report ***********
reportMsg = reportMsg + "\n@1. CXg[󋵁F";
if (testInstallation == null)
{
    reportMsg = reportMsg + "s\n@@̃eXgsł܂łB";
    testFailed = true;
}
else if (testInstallation == true)
{
    reportMsg = reportMsg + "\n@@o[W " + iTunesVersion +"  iTunes F܂B";
}
else
{
    reportMsg = reportMsg + "s\n@@iTunes ɃCXg[Ă܂B";
    testFailed = true;
}

//  *********** test 2: version compatibility ***********
reportMsg = reportMsg + "\n\n@2. o[W̌݊F";
if (testVersionCompatible == null)
{
    reportMsg = reportMsg + "XLbv\n@@̃eXg̓XLbv܂B";
}
else if (testVersionCompatible == true)
{
    if (testVersionRecommended == true)
    {
        reportMsg = reportMsg + "\n@@g iTunes ŁALyrics Master p܂B";
    }
    else
    {
        reportMsg = reportMsg + "\n@@g iTunes ͐o[Wł͂܂񂪁ALyircs Master p܂B"
    }
}
else
{
    reportMsg = reportMsg + "s\n@@̃o[W iTunes ł́ALyrics Master Ƃ̘Ag@\͂p܂B";
    testFailed = true;
}

//  *********** test 3: player status ***********
reportMsg = reportMsg + "\n\n@3. Đ󋵁F";
if (testPlayerState == null)
{
    reportMsg = reportMsg + "XLbv\n@@̃eXg̓XLbv܂B";
}
else if ((testPlayerState == true)&&(0 <= iTunesPlayerState)&&(iTunesPlayerState <= 3))
{
    var visiblePlayerState = "";

    if (iTunesPlayerState == 0)
    {
        visiblePlayerState = "~";
    }
    else if (iTunesPlayerState == 1)
    {
        visiblePlayerState = "Đ";
    }
    else if (iTunesPlayerState == 2)
    {
        visiblePlayerState = "蒆";
    }
    else if (iTunesPlayerState == 3)
    {
        visiblePlayerState = "߂";
    }
    else
    {
        visiblePlayerState = "G[ (" + iTunesPlayerState + ")";
        testFailed = true;
    }

    reportMsg = reportMsg + "\n@@Xe[^X " + visiblePlayerState + " ƔF܂B";
}
else
{
    reportMsg = reportMsg + "s\n@@擾ł܂łB";
    testFailed = true;
}

//  *********** test 4: current track ***********
reportMsg = reportMsg + "\n\n@4. Đ̃gbNF";
if (testCurrentTrack == null)
{
    reportMsg = reportMsg + "XLbv\n@@̃eXg̓XLbv܂B";
}
else if (testCurrentTrack == true)
{
    reportMsg = reportMsg + "\n@@u" + iTunesCurrentTrackName +"vĐłB";
}
else
{
    reportMsg = reportMsg + "s\n@@ɔFł܂łB";
    testFailed = true;
}

reportMsg = reportMsg + "\n\nyffz\n@";

if (testFailed)
{
    reportMsg = reportMsg + "eXgŁA̖肪܂B\n@ŐVł iTunes ēxCXg[邱ƂŁA̖͉ꍇ܂B";
    if (iTunesException !== null) {
        reportMsg += [
            "",
            "@J҂ɘAꍇ͈ȉ̏킹Ăm点B",
            "@@G[bZ[W: " + iTunesException.message,
            "@@G[R[h: " + iTunesException.number,
            ""
        ].join('\n')
    }
}
else if (iTunesPlayerState == 0)
{
    reportMsg = reportMsg + "iTunes ŋȂĐĂȂ߁Aꕔ̃eXgsł܂łB\n@iTunes ŋȂĐĂAxeXgsĂB";
}
else
{
    reportMsg = reportMsg + "eXgł́A肪܂łB\n@Lyrics Master  iTunes Ƃ̘Agɖ肪ꍇ́AJ҂܂łm点B";
}

reportMsg = reportMsg + "\n\n̉ʂJ܂ Ctrl-C ƁÃeXg|[g̓eRs[ł܂B";

WScript.Echo(reportMsg);

// *******************************************************************************
//  END MAIN
// *******************************************************************************


function runTest()
{
    try
    {
        var iTunesApp = WScript.CreateObject("iTunes.Application");
        iTunesVersion = iTunesApp.Version;
        testInstallation = true;
    }
    catch (e)
    {
        iTunesException = e;
        testInstallation = false;
        iTunesVersion = "s";
        return;
    }

    try
    {
        testVersionCompatible = iTunesApp.CheckVersion(1, 5);
        if (! testVersionCompatible)
        {
            return;
        }

        testVersionRecommended = iTunesApp.CheckVersion(1, 9);
    }
    catch (e)
    {
        iTunesException = e;
        testVersionCompatible = false;
        testVersionRecommended = false;
        return;
    }

    try
    {
        iTunesPlayerState = iTunesApp.PlayerState;
        testPlayerState = true;

        if (iTunesPlayerState == 0)
        {
            return;
        }
    }
    catch (e)
    {
        iTunesException = e;
        testPlayerState = false;
        return;
    }

    try
    {
        var currentTrack = iTunesApp.CurrentTrack;
        iTunesCurrentTrackName = currentTrack.Name;
        testCurrentTrack = true;
    }
    catch (e)
    {
        iTunesException = e;
        testCurrentTrack = false;
    }

    return;
}
